
(* these definitions are common boilerplate definitions that most programs want to use
   this file is included by default by the compiler, but can be excluded with a switch *)

(* references *)
type ref α = { mutable content: α }
let ref x = { content = x }
let (!) x = x.content
let (:=) cell value = cell.content <- value

(* option type *)
type option α = None | Some of α

(* discarding the return value and returning a unit instead *)
let ignore a = let _ = a in ()

(* used as an infix operator, called the "pipe" *)
let (▷) x f = f x

(* function composition *)
let (∘) f g = λx → f (g x)
  
(* the projection functions for a couple *)
let fst (a, b) = a
let snd (a, b) = b


(* definition of the list and array types should be built in and should
   be optional here, fix if this is not the case *)
(* lists *)
type list α = Nil | Cons of α × (list α) (* TODO: parenthesis should be optional here, fix the parser *)
let (::) a l = Cons (a, l) (* the infix operator "cons" to add an element to the front *)


let abs x = if x >= 0 then x else -1 * x (* TODO: putting -x gives 2 errors: 1) it does not parse, 2) the error message is uninformative *)
let max a b = if a > b then a else b
let min a b = if a < b then a else b


(* the for loop *)
let rec for a b f = 
  if a > b then 
    ()
  else 
    let () = f a in 
    for (a + 1) b f
  
(* the while loop *)
let rec while f g = 
  if f () then 
    let () = g () in 
    while f g
  else 
    ()
